definition module EdSupport;

/*	Auxilary function for 'EdTextWindow' */

import deltaEventIO;

import EdTypes, EdProgramState;

/*	Calculate cursorpos and charnr in a line nearest to 1st arg. The snd arg. is the tab width in
	pixels.
*/
CalcCharNumber :: !Int !Int !TLine !Font -> (!Int,!Int);

/*	'CalcSelection' takes care that the begin of the Selection is always to
	the upper-left of the end of the Selection.
	The first four parameters are the current line nyumber, the curent char number, the
	corresponding x pixel position and the y pixel position. Idem for the 5th, 6th, 7th and 8th
	parameters.
*/
CalcSelection :: !Int !Int !Int !Int !Int !Int !Int !Int -> Selection;

CalcPixelSelection :: !PartTSel !Int !Int !CurLine !Text !Font -> PartPSel;

/*	Returns char number and cursor position of the first non-space, non-tab char. The 1st arg. and
	2nd arg. are the space and the tab pixel width. The boolean indicates whether auto indent is on.
	the tline paremeter is the current current line, the tline result is the portion of the new
	current line before the new cursor position.
*/
IndentCurrentLine :: !Int !Int !Bool !TLine -> (!Int, !Int, !TLine);

/*	Returns the number of elements and the last element of a list.
*/
Length_and_Last	:: !(List String) !Int -> (!Int,!String);

/*	'Insert(One)Line(s)' insert text at the position indicated by 'part tsel'.
	'InsertOneLine' has a string parameter containing the text to be inserted.
	'InsertLines' has an integer parameter indicating the number of text lines top be inserted,
	a string parameter containing the last line of the text to be inserted and a clipboard
	parameter containing the text to be inserted (including the last line).
*/
InsertOneLine :: !EditWindow !PartTSel !String !WindowUpdate -> (!EditWindow, !WindowUpdate);
InsertLines ::	!EditWindow !PartTSel !Int !String !Clipboard !WindowUpdate
				-> (!EditWindow, !WindowUpdate);

/*	'Remove(One)Line(s)' removes text selected by 'part tsel'. 'RemoveOneLine' must be used when
	text is removed within one line. Otherwise 'RemoveLines' must be used.
*/
RemoveOneLine :: !EditWindow !PartTSel -> (!EditWindow, !WindowUpdate);
RemoveLines :: !EditWindow !PartTSel -> (!EditWindow, !WindowUpdate);

/*	Computes the cursor position and optionally the new selection (if the boolean is True).
	The new selection is defined by the four integer parameters indicating the start end end
	line and char numbers.
*/
SetCursorPos_and_Selection ::	!EditWindow !Bool !Int !Int !Int !Int !WindowUpdate
								-> (!EditWindow, !WindowUpdate);
								
/*	'GoLeftInText'/'GoRightInText' move the current position to the left/right according to the
	'key mode'. The first boolean indicates whether the text underneath the cursor should be
	deleted.
	The result contains the new edit window, the string removed and the number of pixels the cursor
	has moved.
*/
GoLeftInText :: !Bool !KeyMode !CurLine !EditWindow -> (!EditWindow, !String, !Int);
GoRightInText :: !Bool !KeyMode !CurLine !EditWindow -> (!EditWindow, !String, !Int);

/*	'GoUpInText'/'GoDownInText' move the current position up or down according to the 'key mode'.
	The picture domain contains the currently visable portion of the screen. The two integer
	parameters are the current line and character number.
*/
GoUpInText :: !PictureDomain !KeyMode !Int !Int !EditWindow -> EditWindow;
GoDownInText :: !PictureDomain !KeyMode !Int !Int !EditWindow -> EditWindow;

// RWS ...
/* this function is compatible with patchbin in the Unix Clean
   distribution (1.3), variableName should be ' ' (space) padded
   to 10 characters, value should end with a null character
*/ 
PatchableValue :: {#Char} {#Char} -> {#Char};
// ... RWS
